/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.mixins.common;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tech.alexnijjar.endermanoverhaul.common.ModUtils;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.tags.ModEntityTypeTags;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected ItemStack f_20935_;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void endermanoverhaul$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof Player)) {
            return;
        }
        Player entity = (Player)livingEntityMixin;
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (!this.f_20935_.m_150930_((Item)ModItems.CORRUPTED_SHIELD.get())) {
            return;
        }
        if (source.m_19384_() && entity.m_21023_(MobEffects.f_19607_)) {
            return;
        }
        if (!(amount >= 3.0f) || !entity.m_21275_(source)) {
            return;
        }
        ((Player)this).m_36246_(Stats.f_12982_.m_12902_((Object)this.f_20935_.m_41720_()));
        int i = 1 + Mth.m_14143_((float)amount);
        InteractionHand interactionHand = entity.m_7655_();
        this.f_20935_.m_41622_(i, (LivingEntity)entity, player -> player.m_21190_(interactionHand));
        if (this.f_20935_.m_41619_()) {
            if (interactionHand == InteractionHand.MAIN_HAND) {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            } else {
                this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            this.f_20935_ = ItemStack.f_41583_;
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.4f);
        }
    }

    @Inject(method={"blockUsingShield"}, at={@At(value="TAIL")})
    private void endermanoverhaul$blockUsingShield(LivingEntity attacker, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntityMixin;
        if (!this.f_20935_.m_150930_((Item)ModItems.CORRUPTED_SHIELD.get())) {
            return;
        }
        if (attacker.m_6095_().m_204039_(ModEntityTypeTags.CANT_BE_TELEPORTED)) {
            return;
        }
        if (attacker.f_19853_.f_46441_.m_188503_(4) != 0) {
            ModUtils.teleportTarget(attacker.f_19853_, attacker, 32);
            attacker.m_6469_(DamageSource.f_19315_, 2.0f);
        }
        if (attacker.m_213824_()) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)player) * 0.0375f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_((Item)ModItems.CORRUPTED_SHIELD.get(), 100);
                player.m_5810_();
                this.f_19853_.m_7605_((Entity)this, (byte)30);
            }
        }
    }
}

